package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetResolverEndpointResponse(
    resolverEndpoint: Optional[zio.aws.route53resolver.model.ResolverEndpoint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse = {
    import GetResolverEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse
      .builder()
      .optionallyWith(resolverEndpoint.map(value => value.buildAwsValue()))(
        _.resolverEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverEndpointResponse
      .wrap(buildAwsValue())
}
object GetResolverEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverEndpointResponse =
      zio.aws.route53resolver.model.GetResolverEndpointResponse(
        resolverEndpoint.map(value => value.asEditable)
      )
    def resolverEndpoint
        : Optional[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]
    def getResolverEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("resolverEndpoint", resolverEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse
  ) extends zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly {
    override val resolverEndpoint
        : Optional[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverEndpoint())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpoint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverEndpointResponse
  ): zio.aws.route53resolver.model.GetResolverEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
