package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.FirewallRuleGroupPolicy
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFirewallRuleGroupPolicyResponse(
    firewallRuleGroupPolicy: Optional[FirewallRuleGroupPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse = {
    import GetFirewallRuleGroupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse
      .builder()
      .optionallyWith(
        firewallRuleGroupPolicy.map(value =>
          FirewallRuleGroupPolicy.unwrap(value): java.lang.String
        )
      )(_.firewallRuleGroupPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse
      .wrap(buildAwsValue())
}
object GetFirewallRuleGroupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse =
      zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse(
        firewallRuleGroupPolicy.map(value => value)
      )
    def firewallRuleGroupPolicy: Optional[FirewallRuleGroupPolicy]
    def getFirewallRuleGroupPolicy
        : ZIO[Any, AwsError, FirewallRuleGroupPolicy] = AwsError
      .unwrapOptionField("firewallRuleGroupPolicy", firewallRuleGroupPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse
  ) extends zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly {
    override val firewallRuleGroupPolicy: Optional[FirewallRuleGroupPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRuleGroupPolicy())
        .map(value =>
          zio.aws.route53resolver.model.primitives
            .FirewallRuleGroupPolicy(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupPolicyResponse
  ): zio.aws.route53resolver.model.GetFirewallRuleGroupPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
