package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DisassociateResolverRuleRequest(
    vpcId: ResourceId,
    resolverRuleId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest = {
    import DisassociateResolverRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest
      .builder()
      .vpcId(ResourceId.unwrap(vpcId): java.lang.String)
      .resolverRuleId(ResourceId.unwrap(resolverRuleId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DisassociateResolverRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.DisassociateResolverRuleRequest
      .wrap(buildAwsValue())
}
object DisassociateResolverRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DisassociateResolverRuleRequest =
      zio.aws.route53resolver.model
        .DisassociateResolverRuleRequest(vpcId, resolverRuleId)
    def vpcId: ResourceId
    def resolverRuleId: ResourceId
    def getVpcId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(vpcId)
    def getResolverRuleId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest
  ) extends zio.aws.route53resolver.model.DisassociateResolverRuleRequest.ReadOnly {
    override val vpcId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.vpcId())
    override val resolverRuleId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resolverRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateResolverRuleRequest
  ): zio.aws.route53resolver.model.DisassociateResolverRuleRequest.ReadOnly =
    new Wrapper(impl)
}
