package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetResolverQueryLogConfigAssociationRequest(
    resolverQueryLogConfigAssociationId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest = {
    import GetResolverQueryLogConfigAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest
      .builder()
      .resolverQueryLogConfigAssociationId(
        ResourceId.unwrap(resolverQueryLogConfigAssociationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationRequest
      .wrap(buildAwsValue())
}
object GetResolverQueryLogConfigAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationRequest =
      zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationRequest(
        resolverQueryLogConfigAssociationId
      )
    def resolverQueryLogConfigAssociationId: ResourceId
    def getResolverQueryLogConfigAssociationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverQueryLogConfigAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest
  ) extends zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationRequest.ReadOnly {
    override val resolverQueryLogConfigAssociationId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverQueryLogConfigAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverQueryLogConfigAssociationRequest
  ): zio.aws.route53resolver.model.GetResolverQueryLogConfigAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
