package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DeleteFirewallRuleGroupRequest(
    firewallRuleGroupId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest = {
    import DeleteFirewallRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest
      .builder()
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteFirewallRuleGroupRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteFirewallRuleGroupRequest
      .wrap(buildAwsValue())
}
object DeleteFirewallRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteFirewallRuleGroupRequest =
      zio.aws.route53resolver.model
        .DeleteFirewallRuleGroupRequest(firewallRuleGroupId)
    def firewallRuleGroupId: ResourceId
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest
  ) extends zio.aws.route53resolver.model.DeleteFirewallRuleGroupRequest.ReadOnly {
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallRuleGroupRequest
  ): zio.aws.route53resolver.model.DeleteFirewallRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
