package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.{FirewallDomainName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallDomainsRequest(
    firewallDomainListId: ResourceId,
    operation: zio.aws.route53resolver.model.FirewallDomainUpdateOperation,
    domains: Iterable[FirewallDomainName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest = {
    import UpdateFirewallDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest
      .builder()
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .operation(operation.unwrap)
      .domains(domains.map { item =>
        FirewallDomainName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallDomainsRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallDomainsRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateFirewallDomainsRequest =
      zio.aws.route53resolver.model
        .UpdateFirewallDomainsRequest(firewallDomainListId, operation, domains)
    def firewallDomainListId: ResourceId
    def operation: zio.aws.route53resolver.model.FirewallDomainUpdateOperation
    def domains: List[FirewallDomainName]
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
    def getOperation: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.FirewallDomainUpdateOperation
    ] = ZIO.succeed(operation)
    def getDomains: ZIO[Any, Nothing, List[FirewallDomainName]] =
      ZIO.succeed(domains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest
  ) extends zio.aws.route53resolver.model.UpdateFirewallDomainsRequest.ReadOnly {
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
    override val operation
        : zio.aws.route53resolver.model.FirewallDomainUpdateOperation =
      zio.aws.route53resolver.model.FirewallDomainUpdateOperation
        .wrap(impl.operation())
    override val domains: List[FirewallDomainName] = impl
      .domains()
      .asScala
      .map { item =>
        zio.aws.route53resolver.model.primitives.FirewallDomainName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsRequest
  ): zio.aws.route53resolver.model.UpdateFirewallDomainsRequest.ReadOnly =
    new Wrapper(impl)
}
