package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.{DomainListFileUrl, ResourceId}
import scala.jdk.CollectionConverters.*
final case class ImportFirewallDomainsRequest(
    firewallDomainListId: ResourceId,
    operation: zio.aws.route53resolver.model.FirewallDomainImportOperation,
    domainFileUrl: DomainListFileUrl
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest = {
    import ImportFirewallDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest
      .builder()
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .operation(operation.unwrap)
      .domainFileUrl(DomainListFileUrl.unwrap(domainFileUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ImportFirewallDomainsRequest.ReadOnly =
    zio.aws.route53resolver.model.ImportFirewallDomainsRequest
      .wrap(buildAwsValue())
}
object ImportFirewallDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ImportFirewallDomainsRequest =
      zio.aws.route53resolver.model.ImportFirewallDomainsRequest(
        firewallDomainListId,
        operation,
        domainFileUrl
      )
    def firewallDomainListId: ResourceId
    def operation: zio.aws.route53resolver.model.FirewallDomainImportOperation
    def domainFileUrl: DomainListFileUrl
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
    def getOperation: ZIO[
      Any,
      Nothing,
      zio.aws.route53resolver.model.FirewallDomainImportOperation
    ] = ZIO.succeed(operation)
    def getDomainFileUrl: ZIO[Any, Nothing, DomainListFileUrl] =
      ZIO.succeed(domainFileUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest
  ) extends zio.aws.route53resolver.model.ImportFirewallDomainsRequest.ReadOnly {
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
    override val operation
        : zio.aws.route53resolver.model.FirewallDomainImportOperation =
      zio.aws.route53resolver.model.FirewallDomainImportOperation
        .wrap(impl.operation())
    override val domainFileUrl: DomainListFileUrl =
      zio.aws.route53resolver.model.primitives
        .DomainListFileUrl(impl.domainFileUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ImportFirewallDomainsRequest
  ): zio.aws.route53resolver.model.ImportFirewallDomainsRequest.ReadOnly =
    new Wrapper(impl)
}
