package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.{FirewallRuleGroupPolicy, Arn}
import scala.jdk.CollectionConverters.*
final case class PutFirewallRuleGroupPolicyRequest(
    arn: Arn,
    firewallRuleGroupPolicy: FirewallRuleGroupPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest = {
    import PutFirewallRuleGroupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .firewallRuleGroupPolicy(
        FirewallRuleGroupPolicy.unwrap(
          firewallRuleGroupPolicy
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyRequest.ReadOnly =
    zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyRequest
      .wrap(buildAwsValue())
}
object PutFirewallRuleGroupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyRequest =
      zio.aws.route53resolver.model
        .PutFirewallRuleGroupPolicyRequest(arn, firewallRuleGroupPolicy)
    def arn: Arn
    def firewallRuleGroupPolicy: FirewallRuleGroupPolicy
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getFirewallRuleGroupPolicy: ZIO[Any, Nothing, FirewallRuleGroupPolicy] =
      ZIO.succeed(firewallRuleGroupPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest
  ) extends zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.route53resolver.model.primitives.Arn(impl.arn())
    override val firewallRuleGroupPolicy: FirewallRuleGroupPolicy =
      zio.aws.route53resolver.model.primitives
        .FirewallRuleGroupPolicy(impl.firewallRuleGroupPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.PutFirewallRuleGroupPolicyRequest
  ): zio.aws.route53resolver.model.PutFirewallRuleGroupPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
