package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class GetResolverRuleRequest(resolverRuleId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest = {
    import GetResolverRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest
      .builder()
      .resolverRuleId(ResourceId.unwrap(resolverRuleId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.GetResolverRuleRequest.wrap(buildAwsValue())
}
object GetResolverRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetResolverRuleRequest =
      zio.aws.route53resolver.model.GetResolverRuleRequest(resolverRuleId)
    def resolverRuleId: ResourceId
    def getResolverRuleId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest
  ) extends zio.aws.route53resolver.model.GetResolverRuleRequest.ReadOnly {
    override val resolverRuleId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resolverRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRuleRequest
  ): zio.aws.route53resolver.model.GetResolverRuleRequest.ReadOnly =
    new Wrapper(impl)
}
