package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListResolverRulesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    resolverRules: Optional[
      Iterable[zio.aws.route53resolver.model.ResolverRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse = {
    import ListResolverRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resolverRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverRules)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverRulesResponse
      .wrap(buildAwsValue())
}
object ListResolverRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListResolverRulesResponse =
      zio.aws.route53resolver.model.ListResolverRulesResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resolverRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def resolverRules
        : Optional[List[zio.aws.route53resolver.model.ResolverRule.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResolverRules: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ]] = AwsError.unwrapOptionField("resolverRules", resolverRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
  ) extends zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val resolverRules
        : Optional[List[zio.aws.route53resolver.model.ResolverRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolverRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.ResolverRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverRulesResponse
  ): zio.aws.route53resolver.model.ListResolverRulesResponse.ReadOnly =
    new Wrapper(impl)
}
