package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFirewallRuleGroupResponse(
    firewallRuleGroup: Optional[
      zio.aws.route53resolver.model.FirewallRuleGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse = {
    import GetFirewallRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse
      .builder()
      .optionallyWith(firewallRuleGroup.map(value => value.buildAwsValue()))(
        _.firewallRuleGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly =
    zio.aws.route53resolver.model.GetFirewallRuleGroupResponse
      .wrap(buildAwsValue())
}
object GetFirewallRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetFirewallRuleGroupResponse =
      zio.aws.route53resolver.model.GetFirewallRuleGroupResponse(
        firewallRuleGroup.map(value => value.asEditable)
      )
    def firewallRuleGroup
        : Optional[zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly]
    def getFirewallRuleGroup: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly
    ] = AwsError.unwrapOptionField("firewallRuleGroup", firewallRuleGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse
  ) extends zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly {
    override val firewallRuleGroup
        : Optional[zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallRuleGroup())
        .map(value =>
          zio.aws.route53resolver.model.FirewallRuleGroup.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetFirewallRuleGroupResponse
  ): zio.aws.route53resolver.model.GetFirewallRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
