package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  Unsigned,
  AccountId,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FirewallRuleGroup(
    id: Optional[ResourceId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    ruleCount: Optional[Unsigned] = Optional.Absent,
    status: Optional[zio.aws.route53resolver.model.FirewallRuleGroupStatus] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    ownerId: Optional[AccountId] = Optional.Absent,
    creatorRequestId: Optional[CreatorRequestId] = Optional.Absent,
    shareStatus: Optional[zio.aws.route53resolver.model.ShareStatus] =
      Optional.Absent,
    creationTime: Optional[Rfc3339TimeString] = Optional.Absent,
    modificationTime: Optional[Rfc3339TimeString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup = {
    import FirewallRuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(ruleCount.map(value => Unsigned.unwrap(value): Integer))(
        _.ruleCount
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(shareStatus.map(value => value.unwrap))(_.shareStatus)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly =
    zio.aws.route53resolver.model.FirewallRuleGroup.wrap(buildAwsValue())
}
object FirewallRuleGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallRuleGroup =
      zio.aws.route53resolver.model.FirewallRuleGroup(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        ruleCount.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        ownerId.map(value => value),
        creatorRequestId.map(value => value),
        shareStatus.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def id: Optional[ResourceId]
    def arn: Optional[Arn]
    def name: Optional[Name]
    def ruleCount: Optional[Unsigned]
    def status: Optional[zio.aws.route53resolver.model.FirewallRuleGroupStatus]
    def statusMessage: Optional[StatusMessage]
    def ownerId: Optional[AccountId]
    def creatorRequestId: Optional[CreatorRequestId]
    def shareStatus: Optional[zio.aws.route53resolver.model.ShareStatus]
    def creationTime: Optional[Rfc3339TimeString]
    def modificationTime: Optional[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getRuleCount: ZIO[Any, AwsError, Unsigned] =
      AwsError.unwrapOptionField("ruleCount", ruleCount)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallRuleGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getShareStatus
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.ShareStatus] =
      AwsError.unwrapOptionField("shareStatus", shareStatus)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
  ) extends zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val ruleCount: Optional[Unsigned] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleCount())
      .map(value => zio.aws.route53resolver.model.primitives.Unsigned(value))
    override val status
        : Optional[zio.aws.route53resolver.model.FirewallRuleGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.route53resolver.model.FirewallRuleGroupStatus.wrap(value)
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val ownerId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val creatorRequestId: Optional[CreatorRequestId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorRequestId())
        .map(value =>
          zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
        )
    override val shareStatus
        : Optional[zio.aws.route53resolver.model.ShareStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareStatus())
        .map(value => zio.aws.route53resolver.model.ShareStatus.wrap(value))
    override val creationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
    override val modificationTime: Optional[Rfc3339TimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modificationTime())
        .map(value =>
          zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroup
  ): zio.aws.route53resolver.model.FirewallRuleGroup.ReadOnly = new Wrapper(
    impl
  )
}
