package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  ListFirewallConfigsMaxResult
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListFirewallConfigsRequest(
    maxResults: Optional[ListFirewallConfigsMaxResult] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest = {
    import ListFirewallConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListFirewallConfigsMaxResult.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallConfigsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallConfigsRequest
      .wrap(buildAwsValue())
}
object ListFirewallConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListFirewallConfigsRequest =
      zio.aws.route53resolver.model.ListFirewallConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListFirewallConfigsMaxResult]
    def nextToken: Optional[NextToken]
    def getMaxResults: ZIO[Any, AwsError, ListFirewallConfigsMaxResult] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest
  ) extends zio.aws.route53resolver.model.ListFirewallConfigsRequest.ReadOnly {
    override val maxResults: Optional[ListFirewallConfigsMaxResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.route53resolver.model.primitives
            .ListFirewallConfigsMaxResult(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallConfigsRequest
  ): zio.aws.route53resolver.model.ListFirewallConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
