package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{AccountId, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FirewallConfig(
    id: Optional[ResourceId] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    ownerId: Optional[AccountId] = Optional.Absent,
    firewallFailOpen: Optional[
      zio.aws.route53resolver.model.FirewallFailOpenStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallConfig = {
    import FirewallConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallConfig
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(firewallFailOpen.map(value => value.unwrap))(
        _.firewallFailOpen
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.FirewallConfig.ReadOnly =
    zio.aws.route53resolver.model.FirewallConfig.wrap(buildAwsValue())
}
object FirewallConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallConfig =
      zio.aws.route53resolver.model.FirewallConfig(
        id.map(value => value),
        resourceId.map(value => value),
        ownerId.map(value => value),
        firewallFailOpen.map(value => value)
      )
    def id: Optional[ResourceId]
    def resourceId: Optional[ResourceId]
    def ownerId: Optional[AccountId]
    def firewallFailOpen
        : Optional[zio.aws.route53resolver.model.FirewallFailOpenStatus]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getFirewallFailOpen: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallFailOpenStatus
    ] = AwsError.unwrapOptionField("firewallFailOpen", firewallFailOpen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallConfig
  ) extends zio.aws.route53resolver.model.FirewallConfig.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val ownerId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val firewallFailOpen
        : Optional[zio.aws.route53resolver.model.FirewallFailOpenStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallFailOpen())
        .map(value =>
          zio.aws.route53resolver.model.FirewallFailOpenStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallConfig
  ): zio.aws.route53resolver.model.FirewallConfig.ReadOnly = new Wrapper(impl)
}
