package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Name, CreatorRequestId}
import scala.jdk.CollectionConverters.*
final case class CreateFirewallDomainListRequest(
    creatorRequestId: CreatorRequestId,
    name: Name,
    tags: Option[Iterable[zio.aws.route53resolver.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest = {
    import CreateFirewallDomainListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest
      .builder()
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateFirewallDomainListRequest.ReadOnly =
    zio.aws.route53resolver.model.CreateFirewallDomainListRequest
      .wrap(buildAwsValue())
}
object CreateFirewallDomainListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.CreateFirewallDomainListRequest =
      zio.aws.route53resolver.model.CreateFirewallDomainListRequest(
        creatorRequestId,
        name,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def creatorRequestId: CreatorRequestId
    def name: Name
    def tags: Option[List[zio.aws.route53resolver.model.Tag.ReadOnly]]
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest
  ) extends zio.aws.route53resolver.model.CreateFirewallDomainListRequest.ReadOnly {
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val name: Name =
      zio.aws.route53resolver.model.primitives.Name(impl.name())
    override val tags
        : Option[List[zio.aws.route53resolver.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateFirewallDomainListRequest
  ): zio.aws.route53resolver.model.CreateFirewallDomainListRequest.ReadOnly =
    new Wrapper(impl)
}
