package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutResolverQueryLogConfigPolicyResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse = {
    import PutResolverQueryLogConfigPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly =
    zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse
      .wrap(buildAwsValue())
}
object PutResolverQueryLogConfigPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse =
      zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse(
        returnValue.map(value => value)
      )
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse
  ) extends zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverQueryLogConfigPolicyResponse
  ): zio.aws.route53resolver.model.PutResolverQueryLogConfigPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
