package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{AccountId, ResourceId}
import scala.jdk.CollectionConverters.*
final case class FirewallConfig(
    id: Option[ResourceId] = None,
    resourceId: Option[ResourceId] = None,
    ownerId: Option[AccountId] = None,
    firewallFailOpen: Option[
      zio.aws.route53resolver.model.FirewallFailOpenStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallConfig = {
    import FirewallConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallConfig
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(firewallFailOpen.map(value => value.unwrap))(
        _.firewallFailOpen
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.FirewallConfig.ReadOnly =
    zio.aws.route53resolver.model.FirewallConfig.wrap(buildAwsValue())
}
object FirewallConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallConfig =
      zio.aws.route53resolver.model.FirewallConfig(
        id.map(value => value),
        resourceId.map(value => value),
        ownerId.map(value => value),
        firewallFailOpen.map(value => value)
      )
    def id: Option[ResourceId]
    def resourceId: Option[ResourceId]
    def ownerId: Option[AccountId]
    def firewallFailOpen
        : Option[zio.aws.route53resolver.model.FirewallFailOpenStatus]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getFirewallFailOpen: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallFailOpenStatus
    ] = AwsError.unwrapOptionField("firewallFailOpen", firewallFailOpen)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallConfig
  ) extends zio.aws.route53resolver.model.FirewallConfig.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resourceId: Option[ResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val ownerId: Option[AccountId] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val firewallFailOpen
        : Option[zio.aws.route53resolver.model.FirewallFailOpenStatus] = scala
      .Option(impl.firewallFailOpen())
      .map(value =>
        zio.aws.route53resolver.model.FirewallFailOpenStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallConfig
  ): zio.aws.route53resolver.model.FirewallConfig.ReadOnly = new Wrapper(impl)
}
