package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.ResolverRulePolicy
import scala.jdk.CollectionConverters.*
final case class GetResolverRulePolicyResponse(
    resolverRulePolicy: Option[ResolverRulePolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse = {
    import GetResolverRulePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse
      .builder()
      .optionallyWith(
        resolverRulePolicy.map(value =>
          ResolverRulePolicy.unwrap(value): java.lang.String
        )
      )(_.resolverRulePolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverRulePolicyResponse
      .wrap(buildAwsValue())
}
object GetResolverRulePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverRulePolicyResponse =
      zio.aws.route53resolver.model
        .GetResolverRulePolicyResponse(resolverRulePolicy.map(value => value))
    def resolverRulePolicy: Option[ResolverRulePolicy]
    def getResolverRulePolicy: ZIO[Any, AwsError, ResolverRulePolicy] =
      AwsError.unwrapOptionField("resolverRulePolicy", resolverRulePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse
  ) extends zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly {
    override val resolverRulePolicy: Option[ResolverRulePolicy] = scala
      .Option(impl.resolverRulePolicy())
      .map(value =>
        zio.aws.route53resolver.model.primitives.ResolverRulePolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverRulePolicyResponse
  ): zio.aws.route53resolver.model.GetResolverRulePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
