package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  SortByKey,
  NextToken,
  MaxResults
}
import scala.jdk.CollectionConverters.*
final case class ListResolverQueryLogConfigsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    filters: Option[Iterable[zio.aws.route53resolver.model.Filter]] = None,
    sortBy: Option[SortByKey] = None,
    sortOrder: Option[zio.aws.route53resolver.model.SortOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest = {
    import ListResolverQueryLogConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        sortBy.map(value => SortByKey.unwrap(value): java.lang.String)
      )(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverQueryLogConfigsRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverQueryLogConfigsRequest
      .wrap(buildAwsValue())
}
object ListResolverQueryLogConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverQueryLogConfigsRequest =
      zio.aws.route53resolver.model.ListResolverQueryLogConfigsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def filters: Option[List[zio.aws.route53resolver.model.Filter.ReadOnly]]
    def sortBy: Option[SortByKey]
    def sortOrder: Option[zio.aws.route53resolver.model.SortOrder]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getSortBy: ZIO[Any, AwsError, SortByKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest
  ) extends zio.aws.route53resolver.model.ListResolverQueryLogConfigsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val filters
        : Option[List[zio.aws.route53resolver.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.Filter.wrap(item)
        }.toList
      )
    override val sortBy: Option[SortByKey] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.route53resolver.model.primitives.SortByKey(value))
    override val sortOrder: Option[zio.aws.route53resolver.model.SortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.route53resolver.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest
  ): zio.aws.route53resolver.model.ListResolverQueryLogConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
