package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  Arn,
  Name,
  ResourceId,
  ServicePrinciple
}
import scala.jdk.CollectionConverters.*
final case class FirewallDomainListMetadata(
    id: Option[ResourceId] = None,
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    creatorRequestId: Option[CreatorRequestId] = None,
    managedOwnerName: Option[ServicePrinciple] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata = {
    import FirewallDomainListMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        managedOwnerName.map(value =>
          ServicePrinciple.unwrap(value): java.lang.String
        )
      )(_.managedOwnerName)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly =
    zio.aws.route53resolver.model.FirewallDomainListMetadata
      .wrap(buildAwsValue())
}
object FirewallDomainListMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallDomainListMetadata =
      zio.aws.route53resolver.model.FirewallDomainListMetadata(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        creatorRequestId.map(value => value),
        managedOwnerName.map(value => value)
      )
    def id: Option[ResourceId]
    def arn: Option[Arn]
    def name: Option[Name]
    def creatorRequestId: Option[CreatorRequestId]
    def managedOwnerName: Option[ServicePrinciple]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getManagedOwnerName: ZIO[Any, AwsError, ServicePrinciple] =
      AwsError.unwrapOptionField("managedOwnerName", managedOwnerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
  ) extends zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val creatorRequestId: Option[CreatorRequestId] = scala
      .Option(impl.creatorRequestId())
      .map(value =>
        zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
      )
    override val managedOwnerName: Option[ServicePrinciple] = scala
      .Option(impl.managedOwnerName())
      .map(value =>
        zio.aws.route53resolver.model.primitives.ServicePrinciple(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallDomainListMetadata
  ): zio.aws.route53resolver.model.FirewallDomainListMetadata.ReadOnly =
    new Wrapper(impl)
}
