package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteFirewallDomainListResponse(
    firewallDomainList: Option[
      zio.aws.route53resolver.model.FirewallDomainList
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse = {
    import DeleteFirewallDomainListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse
      .builder()
      .optionallyWith(firewallDomainList.map(value => value.buildAwsValue()))(
        _.firewallDomainList
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteFirewallDomainListResponse
      .wrap(buildAwsValue())
}
object DeleteFirewallDomainListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteFirewallDomainListResponse =
      zio.aws.route53resolver.model.DeleteFirewallDomainListResponse(
        firewallDomainList.map(value => value.asEditable)
      )
    def firewallDomainList
        : Option[zio.aws.route53resolver.model.FirewallDomainList.ReadOnly]
    def getFirewallDomainList: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainList.ReadOnly
    ] = AwsError.unwrapOptionField("firewallDomainList", firewallDomainList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse
  ) extends zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly {
    override val firewallDomainList
        : Option[zio.aws.route53resolver.model.FirewallDomainList.ReadOnly] =
      scala
        .Option(impl.firewallDomainList())
        .map(value =>
          zio.aws.route53resolver.model.FirewallDomainList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListResponse
  ): zio.aws.route53resolver.model.DeleteFirewallDomainListResponse.ReadOnly =
    new Wrapper(impl)
}
