package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListFirewallRulesResponse(
    nextToken: Option[NextToken] = None,
    firewallRules: Option[
      Iterable[zio.aws.route53resolver.model.FirewallRule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse = {
    import ListFirewallRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        firewallRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firewallRules)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallRulesResponse
      .wrap(buildAwsValue())
}
object ListFirewallRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListFirewallRulesResponse =
      zio.aws.route53resolver.model.ListFirewallRulesResponse(
        nextToken.map(value => value),
        firewallRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def firewallRules
        : Option[List[zio.aws.route53resolver.model.FirewallRule.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFirewallRules: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.FirewallRule.ReadOnly
    ]] = AwsError.unwrapOptionField("firewallRules", firewallRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse
  ) extends zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val firewallRules
        : Option[List[zio.aws.route53resolver.model.FirewallRule.ReadOnly]] =
      scala
        .Option(impl.firewallRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.FirewallRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesResponse
  ): zio.aws.route53resolver.model.ListFirewallRulesResponse.ReadOnly =
    new Wrapper(impl)
}
