package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutResolverRulePolicyResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse = {
    import PutResolverRulePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly =
    zio.aws.route53resolver.model.PutResolverRulePolicyResponse
      .wrap(buildAwsValue())
}
object PutResolverRulePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.PutResolverRulePolicyResponse =
      zio.aws.route53resolver.model
        .PutResolverRulePolicyResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse
  ) extends zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.PutResolverRulePolicyResponse
  ): zio.aws.route53resolver.model.PutResolverRulePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
