package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DisassociateFirewallRuleGroupRequest(
    firewallRuleGroupAssociationId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest = {
    import DisassociateFirewallRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest
      .builder()
      .firewallRuleGroupAssociationId(
        ResourceId.unwrap(firewallRuleGroupAssociationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DisassociateFirewallRuleGroupRequest.ReadOnly =
    zio.aws.route53resolver.model.DisassociateFirewallRuleGroupRequest
      .wrap(buildAwsValue())
}
object DisassociateFirewallRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DisassociateFirewallRuleGroupRequest =
      zio.aws.route53resolver.model
        .DisassociateFirewallRuleGroupRequest(firewallRuleGroupAssociationId)
    def firewallRuleGroupAssociationId: ResourceId
    def getFirewallRuleGroupAssociationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupAssociationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest
  ) extends zio.aws.route53resolver.model.DisassociateFirewallRuleGroupRequest.ReadOnly {
    override val firewallRuleGroupAssociationId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupAssociationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DisassociateFirewallRuleGroupRequest
  ): zio.aws.route53resolver.model.DisassociateFirewallRuleGroupRequest.ReadOnly =
    new Wrapper(impl)
}
