package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteResolverRuleResponse(
    resolverRule: Option[zio.aws.route53resolver.model.ResolverRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse = {
    import DeleteResolverRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse
      .builder()
      .optionallyWith(resolverRule.map(value => value.buildAwsValue()))(
        _.resolverRule
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly =
    zio.aws.route53resolver.model.DeleteResolverRuleResponse
      .wrap(buildAwsValue())
}
object DeleteResolverRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.DeleteResolverRuleResponse =
      zio.aws.route53resolver.model
        .DeleteResolverRuleResponse(resolverRule.map(value => value.asEditable))
    def resolverRule
        : Option[zio.aws.route53resolver.model.ResolverRule.ReadOnly]
    def getResolverRule: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverRule.ReadOnly
    ] = AwsError.unwrapOptionField("resolverRule", resolverRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse
  ) extends zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly {
    override val resolverRule
        : Option[zio.aws.route53resolver.model.ResolverRule.ReadOnly] = scala
      .Option(impl.resolverRule())
      .map(value => zio.aws.route53resolver.model.ResolverRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleResponse
  ): zio.aws.route53resolver.model.DeleteResolverRuleResponse.ReadOnly =
    new Wrapper(impl)
}
