package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateResolverQueryLogConfigResponse(
    resolverQueryLogConfig: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse = {
    import CreateResolverQueryLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse
      .builder()
      .optionallyWith(
        resolverQueryLogConfig.map(value => value.buildAwsValue())
      )(_.resolverQueryLogConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse
      .wrap(buildAwsValue())
}
object CreateResolverQueryLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse =
      zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse(
        resolverQueryLogConfig.map(value => value.asEditable)
      )
    def resolverQueryLogConfig
        : Option[zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly]
    def getResolverQueryLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "resolverQueryLogConfig",
      resolverQueryLogConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse
  ) extends zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly {
    override val resolverQueryLogConfig: Option[
      zio.aws.route53resolver.model.ResolverQueryLogConfig.ReadOnly
    ] = scala
      .Option(impl.resolverQueryLogConfig())
      .map(value =>
        zio.aws.route53resolver.model.ResolverQueryLogConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateResolverQueryLogConfigResponse
  ): zio.aws.route53resolver.model.CreateResolverQueryLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
