package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  BlockOverrideTtl,
  BlockOverrideDomain,
  Priority,
  Name,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallRuleRequest(
    firewallRuleGroupId: ResourceId,
    firewallDomainListId: ResourceId,
    priority: Option[Priority] = None,
    action: Option[zio.aws.route53resolver.model.Action] = None,
    blockResponse: Option[zio.aws.route53resolver.model.BlockResponse] = None,
    blockOverrideDomain: Option[BlockOverrideDomain] = None,
    blockOverrideDnsType: Option[
      zio.aws.route53resolver.model.BlockOverrideDnsType
    ] = None,
    blockOverrideTtl: Option[BlockOverrideTtl] = None,
    name: Option[Name] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest = {
    import UpdateFirewallRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest
      .builder()
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(blockResponse.map(value => value.unwrap))(_.blockResponse)
      .optionallyWith(
        blockOverrideDomain.map(value =>
          BlockOverrideDomain.unwrap(value): java.lang.String
        )
      )(_.blockOverrideDomain)
      .optionallyWith(blockOverrideDnsType.map(value => value.unwrap))(
        _.blockOverrideDnsType
      )
      .optionallyWith(
        blockOverrideTtl.map(value => BlockOverrideTtl.unwrap(value): Integer)
      )(_.blockOverrideTtl)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallRuleRequest
      .wrap(buildAwsValue())
}
object UpdateFirewallRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.UpdateFirewallRuleRequest =
      zio.aws.route53resolver.model.UpdateFirewallRuleRequest(
        firewallRuleGroupId,
        firewallDomainListId,
        priority.map(value => value),
        action.map(value => value),
        blockResponse.map(value => value),
        blockOverrideDomain.map(value => value),
        blockOverrideDnsType.map(value => value),
        blockOverrideTtl.map(value => value),
        name.map(value => value)
      )
    def firewallRuleGroupId: ResourceId
    def firewallDomainListId: ResourceId
    def priority: Option[Priority]
    def action: Option[zio.aws.route53resolver.model.Action]
    def blockResponse: Option[zio.aws.route53resolver.model.BlockResponse]
    def blockOverrideDomain: Option[BlockOverrideDomain]
    def blockOverrideDnsType
        : Option[zio.aws.route53resolver.model.BlockOverrideDnsType]
    def blockOverrideTtl: Option[BlockOverrideTtl]
    def name: Option[Name]
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getAction: ZIO[Any, AwsError, zio.aws.route53resolver.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBlockResponse
        : ZIO[Any, AwsError, zio.aws.route53resolver.model.BlockResponse] =
      AwsError.unwrapOptionField("blockResponse", blockResponse)
    def getBlockOverrideDomain: ZIO[Any, AwsError, BlockOverrideDomain] =
      AwsError.unwrapOptionField("blockOverrideDomain", blockOverrideDomain)
    def getBlockOverrideDnsType: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.BlockOverrideDnsType
    ] = AwsError.unwrapOptionField("blockOverrideDnsType", blockOverrideDnsType)
    def getBlockOverrideTtl: ZIO[Any, AwsError, BlockOverrideTtl] =
      AwsError.unwrapOptionField("blockOverrideTtl", blockOverrideTtl)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest
  ) extends zio.aws.route53resolver.model.UpdateFirewallRuleRequest.ReadOnly {
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
    override val priority: Option[Priority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.route53resolver.model.primitives.Priority(value))
    override val action: Option[zio.aws.route53resolver.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.route53resolver.model.Action.wrap(value))
    override val blockResponse
        : Option[zio.aws.route53resolver.model.BlockResponse] = scala
      .Option(impl.blockResponse())
      .map(value => zio.aws.route53resolver.model.BlockResponse.wrap(value))
    override val blockOverrideDomain: Option[BlockOverrideDomain] = scala
      .Option(impl.blockOverrideDomain())
      .map(value =>
        zio.aws.route53resolver.model.primitives.BlockOverrideDomain(value)
      )
    override val blockOverrideDnsType
        : Option[zio.aws.route53resolver.model.BlockOverrideDnsType] = scala
      .Option(impl.blockOverrideDnsType())
      .map(value =>
        zio.aws.route53resolver.model.BlockOverrideDnsType.wrap(value)
      )
    override val blockOverrideTtl: Option[BlockOverrideTtl] = scala
      .Option(impl.blockOverrideTtl())
      .map(value =>
        zio.aws.route53resolver.model.primitives.BlockOverrideTtl(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallRuleRequest
  ): zio.aws.route53resolver.model.UpdateFirewallRuleRequest.ReadOnly =
    new Wrapper(impl)
}
