package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListResolverEndpointsResponse(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    resolverEndpoints: Option[
      Iterable[zio.aws.route53resolver.model.ResolverEndpoint]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse = {
    import ListResolverEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        resolverEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resolverEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointsResponse
      .wrap(buildAwsValue())
}
object ListResolverEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverEndpointsResponse =
      zio.aws.route53resolver.model.ListResolverEndpointsResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        resolverEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def resolverEndpoints
        : Option[List[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getResolverEndpoints: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("resolverEndpoints", resolverEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
  ) extends zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val resolverEndpoints: Option[
      List[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]
    ] = scala
      .Option(impl.resolverEndpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.ResolverEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointsResponse
  ): zio.aws.route53resolver.model.ListResolverEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
