package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  StatusMessage,
  Name,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class UpdateFirewallDomainsResponse(
    id: Option[ResourceId] = None,
    name: Option[Name] = None,
    status: Option[zio.aws.route53resolver.model.FirewallDomainListStatus] =
      None,
    statusMessage: Option[StatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse = {
    import UpdateFirewallDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateFirewallDomainsResponse
      .wrap(buildAwsValue())
}
object UpdateFirewallDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateFirewallDomainsResponse =
      zio.aws.route53resolver.model.UpdateFirewallDomainsResponse(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def id: Option[ResourceId]
    def name: Option[Name]
    def status: Option[zio.aws.route53resolver.model.FirewallDomainListStatus]
    def statusMessage: Option[StatusMessage]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainListStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse
  ) extends zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val status
        : Option[zio.aws.route53resolver.model.FirewallDomainListStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.FirewallDomainListStatus.wrap(value)
      )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateFirewallDomainsResponse
  ): zio.aws.route53resolver.model.UpdateFirewallDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
