package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  IpAddressCount,
  CreatorRequestId,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage
}
import scala.jdk.CollectionConverters.*
final case class ResolverEndpoint(
    id: Option[ResourceId] = None,
    creatorRequestId: Option[CreatorRequestId] = None,
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    securityGroupIds: Option[Iterable[ResourceId]] = None,
    direction: Option[zio.aws.route53resolver.model.ResolverEndpointDirection] =
      None,
    ipAddressCount: Option[IpAddressCount] = None,
    hostVPCId: Option[ResourceId] = None,
    status: Option[zio.aws.route53resolver.model.ResolverEndpointStatus] = None,
    statusMessage: Option[StatusMessage] = None,
    creationTime: Option[Rfc3339TimeString] = None,
    modificationTime: Option[Rfc3339TimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint = {
    import ResolverEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(direction.map(value => value.unwrap))(_.direction)
      .optionallyWith(
        ipAddressCount.map(value => IpAddressCount.unwrap(value): Integer)
      )(_.ipAddressCount)
      .optionallyWith(
        hostVPCId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostVPCId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly =
    zio.aws.route53resolver.model.ResolverEndpoint.wrap(buildAwsValue())
}
object ResolverEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverEndpoint =
      zio.aws.route53resolver.model.ResolverEndpoint(
        id.map(value => value),
        creatorRequestId.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        securityGroupIds.map(value => value),
        direction.map(value => value),
        ipAddressCount.map(value => value),
        hostVPCId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def id: Option[ResourceId]
    def creatorRequestId: Option[CreatorRequestId]
    def arn: Option[Arn]
    def name: Option[Name]
    def securityGroupIds: Option[List[ResourceId]]
    def direction
        : Option[zio.aws.route53resolver.model.ResolverEndpointDirection]
    def ipAddressCount: Option[IpAddressCount]
    def hostVPCId: Option[ResourceId]
    def status: Option[zio.aws.route53resolver.model.ResolverEndpointStatus]
    def statusMessage: Option[StatusMessage]
    def creationTime: Option[Rfc3339TimeString]
    def modificationTime: Option[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getDirection: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpointDirection
    ] = AwsError.unwrapOptionField("direction", direction)
    def getIpAddressCount: ZIO[Any, AwsError, IpAddressCount] =
      AwsError.unwrapOptionField("ipAddressCount", ipAddressCount)
    def getHostVPCId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostVPCId", hostVPCId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpointStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
  ) extends zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val creatorRequestId: Option[CreatorRequestId] = scala
      .Option(impl.creatorRequestId())
      .map(value =>
        zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
      )
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val securityGroupIds: Option[List[ResourceId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.primitives.ResourceId(item)
        }.toList
      )
    override val direction
        : Option[zio.aws.route53resolver.model.ResolverEndpointDirection] =
      scala
        .Option(impl.direction())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpointDirection.wrap(value)
        )
    override val ipAddressCount: Option[IpAddressCount] = scala
      .Option(impl.ipAddressCount())
      .map(value =>
        zio.aws.route53resolver.model.primitives.IpAddressCount(value)
      )
    override val hostVPCId: Option[ResourceId] = scala
      .Option(impl.hostVPCId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val status
        : Option[zio.aws.route53resolver.model.ResolverEndpointStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.ResolverEndpointStatus.wrap(value)
      )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val creationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
    override val modificationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.modificationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverEndpoint
  ): zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly = new Wrapper(impl)
}
