package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  MaxResults,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class ListResolverEndpointIpAddressesRequest(
    resolverEndpointId: ResourceId,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest = {
    import ListResolverEndpointIpAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
      .builder()
      .resolverEndpointId(
        ResourceId.unwrap(resolverEndpointId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest
      .wrap(buildAwsValue())
}
object ListResolverEndpointIpAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest =
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest(
        resolverEndpointId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resolverEndpointId: ResourceId
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getResolverEndpointId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverEndpointId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
  ) extends zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest.ReadOnly {
    override val resolverEndpointId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.resolverEndpointId())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesRequest
  ): zio.aws.route53resolver.model.ListResolverEndpointIpAddressesRequest.ReadOnly =
    new Wrapper(impl)
}
