package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DeleteResolverRuleRequest(resolverRuleId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest = {
    import DeleteResolverRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest
      .builder()
      .resolverRuleId(ResourceId.unwrap(resolverRuleId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteResolverRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteResolverRuleRequest
      .wrap(buildAwsValue())
}
object DeleteResolverRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.DeleteResolverRuleRequest =
      zio.aws.route53resolver.model.DeleteResolverRuleRequest(resolverRuleId)
    def resolverRuleId: ResourceId
    def getResolverRuleId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest
  ) extends zio.aws.route53resolver.model.DeleteResolverRuleRequest.ReadOnly {
    override val resolverRuleId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resolverRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteResolverRuleRequest
  ): zio.aws.route53resolver.model.DeleteResolverRuleRequest.ReadOnly =
    new Wrapper(impl)
}
