package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateResolverEndpointResponse(
    resolverEndpoint: Option[zio.aws.route53resolver.model.ResolverEndpoint] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse = {
    import UpdateResolverEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse
      .builder()
      .optionallyWith(resolverEndpoint.map(value => value.buildAwsValue()))(
        _.resolverEndpoint
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverEndpointResponse
      .wrap(buildAwsValue())
}
object UpdateResolverEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateResolverEndpointResponse =
      zio.aws.route53resolver.model.UpdateResolverEndpointResponse(
        resolverEndpoint.map(value => value.asEditable)
      )
    def resolverEndpoint
        : Option[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly]
    def getResolverEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("resolverEndpoint", resolverEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse
  ) extends zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly {
    override val resolverEndpoint
        : Option[zio.aws.route53resolver.model.ResolverEndpoint.ReadOnly] =
      scala
        .Option(impl.resolverEndpoint())
        .map(value =>
          zio.aws.route53resolver.model.ResolverEndpoint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverEndpointResponse
  ): zio.aws.route53resolver.model.UpdateResolverEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
