package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{ResourceId, Name}
import scala.jdk.CollectionConverters.*
final case class ResolverRuleConfig(
    name: Option[Name] = None,
    targetIps: Option[Iterable[zio.aws.route53resolver.model.TargetAddress]] =
      None,
    resolverEndpointId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverRuleConfig = {
    import ResolverRuleConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverRuleConfig
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        targetIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetIps)
      .optionallyWith(
        resolverEndpointId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.resolverEndpointId)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverRuleConfig.ReadOnly =
    zio.aws.route53resolver.model.ResolverRuleConfig.wrap(buildAwsValue())
}
object ResolverRuleConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverRuleConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverRuleConfig =
      zio.aws.route53resolver.model.ResolverRuleConfig(
        name.map(value => value),
        targetIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resolverEndpointId.map(value => value)
      )
    def name: Option[Name]
    def targetIps
        : Option[List[zio.aws.route53resolver.model.TargetAddress.ReadOnly]]
    def resolverEndpointId: Option[ResourceId]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getTargetIps: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.TargetAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("targetIps", targetIps)
    def getResolverEndpointId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resolverEndpointId", resolverEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRuleConfig
  ) extends zio.aws.route53resolver.model.ResolverRuleConfig.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val targetIps
        : Option[List[zio.aws.route53resolver.model.TargetAddress.ReadOnly]] =
      scala
        .Option(impl.targetIps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.TargetAddress.wrap(item)
          }.toList
        )
    override val resolverEndpointId: Option[ResourceId] = scala
      .Option(impl.resolverEndpointId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverRuleConfig
  ): zio.aws.route53resolver.model.ResolverRuleConfig.ReadOnly = new Wrapper(
    impl
  )
}
