package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  NextToken,
  MaxResults,
  Priority,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class ListFirewallRulesRequest(
    firewallRuleGroupId: ResourceId,
    priority: Option[Priority] = None,
    action: Option[zio.aws.route53resolver.model.Action] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest = {
    import ListFirewallRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest
      .builder()
      .firewallRuleGroupId(
        ResourceId.unwrap(firewallRuleGroupId): java.lang.String
      )
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallRulesRequest.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallRulesRequest.wrap(buildAwsValue())
}
object ListFirewallRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListFirewallRulesRequest =
      zio.aws.route53resolver.model.ListFirewallRulesRequest(
        firewallRuleGroupId,
        priority.map(value => value),
        action.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def firewallRuleGroupId: ResourceId
    def priority: Option[Priority]
    def action: Option[zio.aws.route53resolver.model.Action]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getFirewallRuleGroupId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallRuleGroupId)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getAction: ZIO[Any, AwsError, zio.aws.route53resolver.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest
  ) extends zio.aws.route53resolver.model.ListFirewallRulesRequest.ReadOnly {
    override val firewallRuleGroupId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallRuleGroupId())
    override val priority: Option[Priority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.route53resolver.model.primitives.Priority(value))
    override val action: Option[zio.aws.route53resolver.model.Action] = scala
      .Option(impl.action())
      .map(value => zio.aws.route53resolver.model.Action.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallRulesRequest
  ): zio.aws.route53resolver.model.ListFirewallRulesRequest.ReadOnly =
    new Wrapper(impl)
}
