package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetResolverDnssecConfigResponse(
    resolverDNSSECConfig: Option[
      zio.aws.route53resolver.model.ResolverDnssecConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse = {
    import GetResolverDnssecConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse
      .builder()
      .optionallyWith(resolverDNSSECConfig.map(value => value.buildAwsValue()))(
        _.resolverDNSSECConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.GetResolverDnssecConfigResponse
      .wrap(buildAwsValue())
}
object GetResolverDnssecConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.GetResolverDnssecConfigResponse =
      zio.aws.route53resolver.model.GetResolverDnssecConfigResponse(
        resolverDNSSECConfig.map(value => value.asEditable)
      )
    def resolverDNSSECConfig
        : Option[zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly]
    def getResolverDNSSECConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resolverDNSSECConfig", resolverDNSSECConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse
  ) extends zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly {
    override val resolverDNSSECConfig
        : Option[zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly] =
      scala
        .Option(impl.resolverDNSSECConfig())
        .map(value =>
          zio.aws.route53resolver.model.ResolverDnssecConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetResolverDnssecConfigResponse
  ): zio.aws.route53resolver.model.GetResolverDnssecConfigResponse.ReadOnly =
    new Wrapper(impl)
}
