package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListResolverEndpointIpAddressesResponse(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    ipAddresses: Option[
      Iterable[zio.aws.route53resolver.model.IpAddressResponse]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse = {
    import ListResolverEndpointIpAddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly =
    zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse
      .wrap(buildAwsValue())
}
object ListResolverEndpointIpAddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse =
      zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse(
        nextToken.map(value => value),
        maxResults.map(value => value),
        ipAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def ipAddresses
        : Option[List[zio.aws.route53resolver.model.IpAddressResponse.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.route53resolver.model.IpAddressResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("ipAddresses", ipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
  ) extends zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.route53resolver.model.primitives.MaxResults(value))
    override val ipAddresses: Option[
      List[zio.aws.route53resolver.model.IpAddressResponse.ReadOnly]
    ] = scala
      .Option(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.IpAddressResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListResolverEndpointIpAddressesResponse
  ): zio.aws.route53resolver.model.ListResolverEndpointIpAddressesResponse.ReadOnly =
    new Wrapper(impl)
}
