package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters.*
sealed trait BlockOverrideDnsType {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType
}
object BlockOverrideDnsType {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType
  ): zio.aws.route53resolver.model.BlockOverrideDnsType = value match {
    case software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType.CNAME =>
      val r = CNAME
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.BlockOverrideDnsType {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType =
      software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType.UNKNOWN_TO_SDK_VERSION
  }
  case object CNAME extends zio.aws.route53resolver.model.BlockOverrideDnsType {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType =
      software.amazon.awssdk.services.route53resolver.model.BlockOverrideDnsType.CNAME
  }
}
