package zio.aws.route53resolver
import zio.prelude.Subtype
import zio.aws.route53resolver.model.primitives.{
  TagKey,
  ResourceId,
  FirewallDomainName,
  FilterValue
}
import zio.aws.route53resolver.model.primitives.ListResolverConfigsMaxResult.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.route53resolver.model.primitives.AccountId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.route53resolver.model.primitives.Arn.Type
    object BlockOverrideDomain extends Subtype[String]
    type BlockOverrideDomain =
      zio.aws.route53resolver.model.primitives.BlockOverrideDomain.Type
    object BlockOverrideTtl extends Subtype[Int]
    type BlockOverrideTtl =
      zio.aws.route53resolver.model.primitives.BlockOverrideTtl.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.route53resolver.model.primitives.Count.Type
    object CreatorRequestId extends Subtype[String]
    type CreatorRequestId =
      zio.aws.route53resolver.model.primitives.CreatorRequestId.Type
    object DestinationArn extends Subtype[String]
    type DestinationArn =
      zio.aws.route53resolver.model.primitives.DestinationArn.Type
    object DomainListFileUrl extends Subtype[String]
    type DomainListFileUrl =
      zio.aws.route53resolver.model.primitives.DomainListFileUrl.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.route53resolver.model.primitives.DomainName.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.route53resolver.model.primitives.FilterName.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.route53resolver.model.primitives.FilterValue.Type
    object FirewallDomainName extends Subtype[String]
    type FirewallDomainName =
      zio.aws.route53resolver.model.primitives.FirewallDomainName.Type
    object FirewallRuleGroupPolicy extends Subtype[String]
    type FirewallRuleGroupPolicy =
      zio.aws.route53resolver.model.primitives.FirewallRuleGroupPolicy.Type
    object Ip extends Subtype[String]
    type Ip = zio.aws.route53resolver.model.primitives.Ip.Type
    object IpAddressCount extends Subtype[Int]
    type IpAddressCount =
      zio.aws.route53resolver.model.primitives.IpAddressCount.Type
    object ListDomainMaxResults extends Subtype[Int]
    type ListDomainMaxResults =
      zio.aws.route53resolver.model.primitives.ListDomainMaxResults.Type
    object ListFirewallConfigsMaxResult extends Subtype[Int]
    type ListFirewallConfigsMaxResult =
      zio.aws.route53resolver.model.primitives.ListFirewallConfigsMaxResult.Type
    object ListResolverConfigsMaxResult extends Subtype[Int]
    type ListResolverConfigsMaxResult =
      zio.aws.route53resolver.model.primitives.ListResolverConfigsMaxResult.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.route53resolver.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.route53resolver.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.route53resolver.model.primitives.NextToken.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.route53resolver.model.primitives.Port.Type
    object Priority extends Subtype[Int]
    type Priority = zio.aws.route53resolver.model.primitives.Priority.Type
    object ResolverQueryLogConfigAssociationErrorMessage extends Subtype[String]
    type ResolverQueryLogConfigAssociationErrorMessage =
      zio.aws.route53resolver.model.primitives.ResolverQueryLogConfigAssociationErrorMessage.Type
    object ResolverQueryLogConfigName extends Subtype[String]
    type ResolverQueryLogConfigName =
      zio.aws.route53resolver.model.primitives.ResolverQueryLogConfigName.Type
    object ResolverQueryLogConfigPolicy extends Subtype[String]
    type ResolverQueryLogConfigPolicy =
      zio.aws.route53resolver.model.primitives.ResolverQueryLogConfigPolicy.Type
    object ResolverRulePolicy extends Subtype[String]
    type ResolverRulePolicy =
      zio.aws.route53resolver.model.primitives.ResolverRulePolicy.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.route53resolver.model.primitives.ResourceId.Type
    object Rfc3339TimeString extends Subtype[String]
    type Rfc3339TimeString =
      zio.aws.route53resolver.model.primitives.Rfc3339TimeString.Type
    object ServicePrinciple extends Subtype[String]
    type ServicePrinciple =
      zio.aws.route53resolver.model.primitives.ServicePrinciple.Type
    object SortByKey extends Subtype[String]
    type SortByKey = zio.aws.route53resolver.model.primitives.SortByKey.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage =
      zio.aws.route53resolver.model.primitives.StatusMessage.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.route53resolver.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.route53resolver.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.route53resolver.model.primitives.TagValue.Type
    object Unsigned extends Subtype[Int]
    type Unsigned = zio.aws.route53resolver.model.primitives.Unsigned.Type
  }
  type FilterValues = List[FilterValue]
  type Filters = List[zio.aws.route53resolver.model.Filter]
  type FirewallConfigList = List[zio.aws.route53resolver.model.FirewallConfig]
  type FirewallDomainListMetadataList =
    List[zio.aws.route53resolver.model.FirewallDomainListMetadata]
  type FirewallDomains = List[FirewallDomainName]
  type FirewallRuleGroupAssociations =
    List[zio.aws.route53resolver.model.FirewallRuleGroupAssociation]
  type FirewallRuleGroupMetadataList =
    List[zio.aws.route53resolver.model.FirewallRuleGroupMetadata]
  type FirewallRules = List[zio.aws.route53resolver.model.FirewallRule]
  type IpAddressesRequest = List[zio.aws.route53resolver.model.IpAddressRequest]
  type IpAddressesResponse =
    List[zio.aws.route53resolver.model.IpAddressResponse]
  type ResolverConfigList = List[zio.aws.route53resolver.model.ResolverConfig]
  type ResolverDnssecConfigList =
    List[zio.aws.route53resolver.model.ResolverDnssecConfig]
  type ResolverEndpoints = List[zio.aws.route53resolver.model.ResolverEndpoint]
  type ResolverQueryLogConfigAssociationList =
    List[zio.aws.route53resolver.model.ResolverQueryLogConfigAssociation]
  type ResolverQueryLogConfigList =
    List[zio.aws.route53resolver.model.ResolverQueryLogConfig]
  type ResolverRuleAssociations =
    List[zio.aws.route53resolver.model.ResolverRuleAssociation]
  type ResolverRules = List[zio.aws.route53resolver.model.ResolverRule]
  type SecurityGroupIds = List[ResourceId]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.route53resolver.model.Tag]
  type TargetList = List[zio.aws.route53resolver.model.TargetAddress]
}
