package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{FirewallDomainName, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListFirewallDomainsResponse(
    nextToken: Option[NextToken] = None,
    domains: Option[Iterable[FirewallDomainName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse = {
    import ListFirewallDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        domains.map(value =>
          value.map { item =>
            FirewallDomainName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.domains)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly =
    zio.aws.route53resolver.model.ListFirewallDomainsResponse
      .wrap(buildAwsValue())
}
object ListFirewallDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ListFirewallDomainsResponse =
      zio.aws.route53resolver.model.ListFirewallDomainsResponse(
        nextToken.map(value => value),
        domains.map(value => value)
      )
    def nextToken: Option[NextToken]
    def domains: Option[List[FirewallDomainName]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDomains: ZIO[Any, AwsError, List[FirewallDomainName]] =
      AwsError.unwrapOptionField("domains", domains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse
  ) extends zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.route53resolver.model.primitives.NextToken(value))
    override val domains: Option[List[FirewallDomainName]] = scala
      .Option(impl.domains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53resolver.model.primitives.FirewallDomainName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ListFirewallDomainsResponse
  ): zio.aws.route53resolver.model.ListFirewallDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
