package zio.aws.route53resolver.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{
  CreatorRequestId,
  Unsigned,
  Arn,
  Rfc3339TimeString,
  Name,
  ResourceId,
  StatusMessage,
  ServicePrinciple
}
import scala.jdk.CollectionConverters.*
final case class FirewallDomainList(
    id: Option[ResourceId] = None,
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    domainCount: Option[Unsigned] = None,
    status: Option[zio.aws.route53resolver.model.FirewallDomainListStatus] =
      None,
    statusMessage: Option[StatusMessage] = None,
    managedOwnerName: Option[ServicePrinciple] = None,
    creatorRequestId: Option[CreatorRequestId] = None,
    creationTime: Option[Rfc3339TimeString] = None,
    modificationTime: Option[Rfc3339TimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.FirewallDomainList = {
    import FirewallDomainList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.FirewallDomainList
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        domainCount.map(value => Unsigned.unwrap(value): Integer)
      )(_.domainCount)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        managedOwnerName.map(value =>
          ServicePrinciple.unwrap(value): java.lang.String
        )
      )(_.managedOwnerName)
      .optionallyWith(
        creatorRequestId.map(value =>
          CreatorRequestId.unwrap(value): java.lang.String
        )
      )(_.creatorRequestId)
      .optionallyWith(
        creationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.creationTime)
      .optionallyWith(
        modificationTime.map(value =>
          Rfc3339TimeString.unwrap(value): java.lang.String
        )
      )(_.modificationTime)
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.FirewallDomainList.ReadOnly =
    zio.aws.route53resolver.model.FirewallDomainList.wrap(buildAwsValue())
}
object FirewallDomainList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.FirewallDomainList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.FirewallDomainList =
      zio.aws.route53resolver.model.FirewallDomainList(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        domainCount.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        managedOwnerName.map(value => value),
        creatorRequestId.map(value => value),
        creationTime.map(value => value),
        modificationTime.map(value => value)
      )
    def id: Option[ResourceId]
    def arn: Option[Arn]
    def name: Option[Name]
    def domainCount: Option[Unsigned]
    def status: Option[zio.aws.route53resolver.model.FirewallDomainListStatus]
    def statusMessage: Option[StatusMessage]
    def managedOwnerName: Option[ServicePrinciple]
    def creatorRequestId: Option[CreatorRequestId]
    def creationTime: Option[Rfc3339TimeString]
    def modificationTime: Option[Rfc3339TimeString]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDomainCount: ZIO[Any, AwsError, Unsigned] =
      AwsError.unwrapOptionField("domainCount", domainCount)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.FirewallDomainListStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getManagedOwnerName: ZIO[Any, AwsError, ServicePrinciple] =
      AwsError.unwrapOptionField("managedOwnerName", managedOwnerName)
    def getCreatorRequestId: ZIO[Any, AwsError, CreatorRequestId] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getCreationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModificationTime: ZIO[Any, AwsError, Rfc3339TimeString] =
      AwsError.unwrapOptionField("modificationTime", modificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallDomainList
  ) extends zio.aws.route53resolver.model.FirewallDomainList.ReadOnly {
    override val id: Option[ResourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.route53resolver.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val domainCount: Option[Unsigned] = scala
      .Option(impl.domainCount())
      .map(value => zio.aws.route53resolver.model.primitives.Unsigned(value))
    override val status
        : Option[zio.aws.route53resolver.model.FirewallDomainListStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.route53resolver.model.FirewallDomainListStatus.wrap(value)
      )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value =>
        zio.aws.route53resolver.model.primitives.StatusMessage(value)
      )
    override val managedOwnerName: Option[ServicePrinciple] = scala
      .Option(impl.managedOwnerName())
      .map(value =>
        zio.aws.route53resolver.model.primitives.ServicePrinciple(value)
      )
    override val creatorRequestId: Option[CreatorRequestId] = scala
      .Option(impl.creatorRequestId())
      .map(value =>
        zio.aws.route53resolver.model.primitives.CreatorRequestId(value)
      )
    override val creationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
    override val modificationTime: Option[Rfc3339TimeString] = scala
      .Option(impl.modificationTime())
      .map(value =>
        zio.aws.route53resolver.model.primitives.Rfc3339TimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.FirewallDomainList
  ): zio.aws.route53resolver.model.FirewallDomainList.ReadOnly = new Wrapper(
    impl
  )
}
