package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DeleteOutpostResolverRequest(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest = {
    import DeleteOutpostResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteOutpostResolverRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteOutpostResolverRequest
      .wrap(buildAwsValue())
}
object DeleteOutpostResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.DeleteOutpostResolverRequest =
      zio.aws.route53resolver.model.DeleteOutpostResolverRequest(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest
  ) extends zio.aws.route53resolver.model.DeleteOutpostResolverRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteOutpostResolverRequest
  ): zio.aws.route53resolver.model.DeleteOutpostResolverRequest.ReadOnly =
    new Wrapper(impl)
}
