package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{Name, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateResolverRuleRequest(
    resolverRuleId: ResourceId,
    name: Optional[Name] = Optional.Absent,
    vpcId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest = {
    import AssociateResolverRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest
      .builder()
      .resolverRuleId(ResourceId.unwrap(resolverRuleId): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .vpcId(ResourceId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.AssociateResolverRuleRequest.ReadOnly =
    zio.aws.route53resolver.model.AssociateResolverRuleRequest
      .wrap(buildAwsValue())
}
object AssociateResolverRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.AssociateResolverRuleRequest =
      zio.aws.route53resolver.model.AssociateResolverRuleRequest(
        resolverRuleId,
        name.map(value => value),
        vpcId
      )
    def resolverRuleId: ResourceId
    def name: Optional[Name]
    def vpcId: ResourceId
    def getResolverRuleId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(resolverRuleId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVpcId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest
  ) extends zio.aws.route53resolver.model.AssociateResolverRuleRequest.ReadOnly {
    override val resolverRuleId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.resolverRuleId())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53resolver.model.primitives.Name(value))
    override val vpcId: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.AssociateResolverRuleRequest
  ): zio.aws.route53resolver.model.AssociateResolverRuleRequest.ReadOnly =
    new Wrapper(impl)
}
