package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetOutpostResolverResponse(
    outpostResolver: Optional[zio.aws.route53resolver.model.OutpostResolver] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse = {
    import GetOutpostResolverResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse
      .builder()
      .optionallyWith(outpostResolver.map(value => value.buildAwsValue()))(
        _.outpostResolver
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetOutpostResolverResponse.ReadOnly =
    zio.aws.route53resolver.model.GetOutpostResolverResponse
      .wrap(buildAwsValue())
}
object GetOutpostResolverResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetOutpostResolverResponse =
      zio.aws.route53resolver.model.GetOutpostResolverResponse(
        outpostResolver.map(value => value.asEditable)
      )
    def outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly]
    def getOutpostResolver: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.OutpostResolver.ReadOnly
    ] = AwsError.unwrapOptionField("outpostResolver", outpostResolver)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse
  ) extends zio.aws.route53resolver.model.GetOutpostResolverResponse.ReadOnly {
    override val outpostResolver
        : Optional[zio.aws.route53resolver.model.OutpostResolver.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outpostResolver())
        .map(value => zio.aws.route53resolver.model.OutpostResolver.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverResponse
  ): zio.aws.route53resolver.model.GetOutpostResolverResponse.ReadOnly =
    new Wrapper(impl)
}
