package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class DeleteFirewallDomainListRequest(
    firewallDomainListId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest = {
    import DeleteFirewallDomainListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest
      .builder()
      .firewallDomainListId(
        ResourceId.unwrap(firewallDomainListId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.DeleteFirewallDomainListRequest.ReadOnly =
    zio.aws.route53resolver.model.DeleteFirewallDomainListRequest
      .wrap(buildAwsValue())
}
object DeleteFirewallDomainListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.DeleteFirewallDomainListRequest =
      zio.aws.route53resolver.model
        .DeleteFirewallDomainListRequest(firewallDomainListId)
    def firewallDomainListId: ResourceId
    def getFirewallDomainListId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(firewallDomainListId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest
  ) extends zio.aws.route53resolver.model.DeleteFirewallDomainListRequest.ReadOnly {
    override val firewallDomainListId: ResourceId =
      zio.aws.route53resolver.model.primitives
        .ResourceId(impl.firewallDomainListId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.DeleteFirewallDomainListRequest
  ): zio.aws.route53resolver.model.DeleteFirewallDomainListRequest.ReadOnly =
    new Wrapper(impl)
}
