package zio.aws.route53resolver.model
import scala.jdk.CollectionConverters._
sealed trait OutpostResolverStatus {
  def unwrap: software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus
}
object OutpostResolverStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus
  ): zio.aws.route53resolver.model.OutpostResolverStatus = value match {
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.OPERATIONAL =>
      val r = OPERATIONAL
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.ACTION_NEEDED =>
      val r = ACTION_NEEDED
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.FAILED_CREATION =>
      val r = FAILED_CREATION
      r
    case software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.FAILED_DELETION =>
      val r = FAILED_DELETION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.CREATING
  }
  case object OPERATIONAL
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.OPERATIONAL
  }
  case object UPDATING
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.UPDATING
  }
  case object DELETING
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.DELETING
  }
  case object ACTION_NEEDED
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.ACTION_NEEDED
  }
  case object FAILED_CREATION
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.FAILED_CREATION
  }
  case object FAILED_DELETION
      extends zio.aws.route53resolver.model.OutpostResolverStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus =
      software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus.FAILED_DELETION
  }
}
