package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateResolverDnssecConfigResponse(
    resolverDNSSECConfig: Optional[
      zio.aws.route53resolver.model.ResolverDnssecConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse = {
    import UpdateResolverDnssecConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse
      .builder()
      .optionallyWith(resolverDNSSECConfig.map(value => value.buildAwsValue()))(
        _.resolverDNSSECConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly =
    zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse
      .wrap(buildAwsValue())
}
object UpdateResolverDnssecConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse =
      zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse(
        resolverDNSSECConfig.map(value => value.asEditable)
      )
    def resolverDNSSECConfig
        : Optional[zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly]
    def getResolverDNSSECConfig: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
    ] = AwsError.unwrapOptionField("resolverDNSSECConfig", resolverDNSSECConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse
  ) extends zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly {
    override val resolverDNSSECConfig: Optional[
      zio.aws.route53resolver.model.ResolverDnssecConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverDNSSECConfig())
      .map(value =>
        zio.aws.route53resolver.model.ResolverDnssecConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.UpdateResolverDnssecConfigResponse
  ): zio.aws.route53resolver.model.UpdateResolverDnssecConfigResponse.ReadOnly =
    new Wrapper(impl)
}
