package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53resolver.model.primitives.ResourceId
import scala.jdk.CollectionConverters._
final case class GetOutpostResolverRequest(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest = {
    import GetOutpostResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.GetOutpostResolverRequest.ReadOnly =
    zio.aws.route53resolver.model.GetOutpostResolverRequest
      .wrap(buildAwsValue())
}
object GetOutpostResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.GetOutpostResolverRequest =
      zio.aws.route53resolver.model.GetOutpostResolverRequest(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest
  ) extends zio.aws.route53resolver.model.GetOutpostResolverRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53resolver.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.GetOutpostResolverRequest
  ): zio.aws.route53resolver.model.GetOutpostResolverRequest.ReadOnly =
    new Wrapper(impl)
}
