package zio.aws.route53resolver.model
import zio.prelude.data.Optional
import zio.aws.route53resolver.model.primitives.{
  OutpostArn,
  CreatorRequestId,
  OutpostResolverName,
  OutpostInstanceType,
  InstanceCount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateOutpostResolverRequest(
    creatorRequestId: CreatorRequestId,
    name: OutpostResolverName,
    instanceCount: Optional[InstanceCount] = Optional.Absent,
    preferredInstanceType: OutpostInstanceType,
    outpostArn: OutpostArn,
    tags: Optional[Iterable[zio.aws.route53resolver.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest = {
    import CreateOutpostResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest
      .builder()
      .creatorRequestId(
        CreatorRequestId.unwrap(creatorRequestId): java.lang.String
      )
      .name(OutpostResolverName.unwrap(name): java.lang.String)
      .optionallyWith(
        instanceCount.map(value => InstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .preferredInstanceType(
        OutpostInstanceType.unwrap(preferredInstanceType): java.lang.String
      )
      .outpostArn(OutpostArn.unwrap(outpostArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.route53resolver.model.CreateOutpostResolverRequest.ReadOnly =
    zio.aws.route53resolver.model.CreateOutpostResolverRequest
      .wrap(buildAwsValue())
}
object CreateOutpostResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.CreateOutpostResolverRequest =
      zio.aws.route53resolver.model.CreateOutpostResolverRequest(
        creatorRequestId,
        name,
        instanceCount.map(value => value),
        preferredInstanceType,
        outpostArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def creatorRequestId: CreatorRequestId
    def name: OutpostResolverName
    def instanceCount: Optional[InstanceCount]
    def preferredInstanceType: OutpostInstanceType
    def outpostArn: OutpostArn
    def tags: Optional[List[zio.aws.route53resolver.model.Tag.ReadOnly]]
    def getCreatorRequestId: ZIO[Any, Nothing, CreatorRequestId] =
      ZIO.succeed(creatorRequestId)
    def getName: ZIO[Any, Nothing, OutpostResolverName] = ZIO.succeed(name)
    def getInstanceCount: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getPreferredInstanceType: ZIO[Any, Nothing, OutpostInstanceType] =
      ZIO.succeed(preferredInstanceType)
    def getOutpostArn: ZIO[Any, Nothing, OutpostArn] = ZIO.succeed(outpostArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest
  ) extends zio.aws.route53resolver.model.CreateOutpostResolverRequest.ReadOnly {
    override val creatorRequestId: CreatorRequestId =
      zio.aws.route53resolver.model.primitives
        .CreatorRequestId(impl.creatorRequestId())
    override val name: OutpostResolverName =
      zio.aws.route53resolver.model.primitives.OutpostResolverName(impl.name())
    override val instanceCount: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value =>
        zio.aws.route53resolver.model.primitives.InstanceCount(value)
      )
    override val preferredInstanceType: OutpostInstanceType =
      zio.aws.route53resolver.model.primitives
        .OutpostInstanceType(impl.preferredInstanceType())
    override val outpostArn: OutpostArn =
      zio.aws.route53resolver.model.primitives.OutpostArn(impl.outpostArn())
    override val tags
        : Optional[List[zio.aws.route53resolver.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53resolver.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.CreateOutpostResolverRequest
  ): zio.aws.route53resolver.model.CreateOutpostResolverRequest.ReadOnly =
    new Wrapper(impl)
}
