package zio.aws.route53resolver.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53resolver.model.primitives.{AccountId, ResourceId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResolverConfig(
    id: Optional[ResourceId] = Optional.Absent,
    resourceId: Optional[ResourceId] = Optional.Absent,
    ownerId: Optional[AccountId] = Optional.Absent,
    autodefinedReverse: Optional[
      zio.aws.route53resolver.model.ResolverAutodefinedReverseStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53resolver.model.ResolverConfig = {
    import ResolverConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53resolver.model.ResolverConfig
      .builder()
      .optionallyWith(
        id.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resourceId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        ownerId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(autodefinedReverse.map(value => value.unwrap))(
        _.autodefinedReverse
      )
      .build()
  }
  def asReadOnly: zio.aws.route53resolver.model.ResolverConfig.ReadOnly =
    zio.aws.route53resolver.model.ResolverConfig.wrap(buildAwsValue())
}
object ResolverConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53resolver.model.ResolverConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53resolver.model.ResolverConfig =
      zio.aws.route53resolver.model.ResolverConfig(
        id.map(value => value),
        resourceId.map(value => value),
        ownerId.map(value => value),
        autodefinedReverse.map(value => value)
      )
    def id: Optional[ResourceId]
    def resourceId: Optional[ResourceId]
    def ownerId: Optional[AccountId]
    def autodefinedReverse: Optional[
      zio.aws.route53resolver.model.ResolverAutodefinedReverseStatus
    ]
    def getId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("id", id)
    def getResourceId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getOwnerId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getAutodefinedReverse: ZIO[
      Any,
      AwsError,
      zio.aws.route53resolver.model.ResolverAutodefinedReverseStatus
    ] = AwsError.unwrapOptionField("autodefinedReverse", autodefinedReverse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverConfig
  ) extends zio.aws.route53resolver.model.ResolverConfig.ReadOnly {
    override val id: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val resourceId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.route53resolver.model.primitives.ResourceId(value))
    override val ownerId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.route53resolver.model.primitives.AccountId(value))
    override val autodefinedReverse: Optional[
      zio.aws.route53resolver.model.ResolverAutodefinedReverseStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autodefinedReverse())
      .map(value =>
        zio.aws.route53resolver.model.ResolverAutodefinedReverseStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53resolver.model.ResolverConfig
  ): zio.aws.route53resolver.model.ResolverConfig.ReadOnly = new Wrapper(impl)
}
